require 'rubygems'
require 'watir-webdriver'
require 'page-object'

require_relative '../pages/landing'
require_relative '../pages/login'
require_relative '../pages/eula'
require_relative '../pages/user_menu'
require_relative '../pages/launchpad'
require_relative '../module/DriverUtility'
require_relative '../pages/appointments/new_appointment_request'
require_relative '../pages/landing_appointments'
require_relative '../pages/community_care/community_Care_PageObject'


class Common
  include PageObject

  @@ccEnabled
  def initialize(driver)
    @driver = driver
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @eula = Eula.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @modal = Modal.new(@driver)
    @cc_po = CommunityCare_PageObject.new(@driver)
    #@new_appointment = NewAppointmentRequest.new(@driver)
  end

  def ccEnabled
    @@ccEnabled
  end

  def loginEndsOnHome(user)
    sleep 5
    @landing.login_element.when_visible(TIME_OUT_LIMIT)
    @landing.login
    waitWhileSpinnerPresent()
    @landing.vaafi_ssoe_element.wait_until_present(TIME_OUT_LIMIT)
    @landing.vaafi_ssoe
    @login.login_element.when_visible(TIME_OUT_LIMIT)
    @login.login_with(user)
    waitWhileSpinnerPresent()
    if(@eula.accept?)
      @eula.accept
    end
    sleep 2
    self.closeEmergencyPopUp
    @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
    sleep 2
  end

  def closeEmergencyPopUp
    button_element = @driver.button(:id => 'crisis-modal-okay')
    button_element.when_present(TIME_OUT_LIMIT)
    @driver.execute_script("$(arguments[0]).click();",button_element)
  end

  def logoutAndLogbackWithADifferentUser(user)
    @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
    #@user_menu.userMenu_element.click
    #workaround - sometimes firefox does not click button
    button_element = @driver.button(:id => 'user-menu-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    @user_menu.logOut_element.when_visible(TIME_OUT_LIMIT)
    link_element = @driver.link(:id => 'logout-btn')
    @driver.execute_script("$(arguments[0]).click();",link_element)
    sleep 3
    wait_until_elements_size_steadied
    @driver.goto(VAR_BASE_URL)
    wait_until_elements_size_steadied
    @landing.login_element.when_visible(TIME_OUT_LIMIT)
    @landing.login
    @landing.vaafi_ssoe_element.wait_until_present(TIME_OUT_LIMIT)
    @landing.vaafi_ssoe
    @login.login_element.when_visible(TIME_OUT_LIMIT)
    @login.login_with(user)
    sleep 2
    waitWhileSpinnerPresent()
    sleep 2
    ## Workaround to login with mockuser02
    if (@modal.isModalPopUpPresent)
      while(@modal.isModalPopUpPresent)
        @modal.buttons_elements[0].click
        waitWhileSpinnerPresent()
        sleep 2
      end
    end

  end


  def waitWhileSpinnerPresent()
    spinner = @driver.div :css => '.loaderModalMask'
    spinner.wait_while_present(90)
  end

  def wait_until_elements_size_steadied(timeout=TIME_OUT_LIMIT)
    @old_size = 0
    @driver.wait
    wait = Selenium::WebDriver::Wait.new(:timeout => timeout)
    wait.until { elements_size_steadied? }
  end

  def elements_size_steadied?
    current_ele = @driver.element.html
    current_size = current_ele.size
    if @old_size == current_size && current_size > 0
      sleep 0.2
      return true
    else
      @old_size = current_size
    end
    return false
  end

  def selectAddAppointmentButton(option)
    sleep 2
    waitWhileSpinnerPresent
    @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
    @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
    @landing_appointments.add_top_btn
    waitWhileSpinnerPresent()
    if(option=="VA" && @landing_appointments.va_appointments?)
      @@ccEnabled = isCCEnabled
      @landing_appointments.select_va_appointments
      @landing_appointments.continue_button
      waitWhileSpinnerPresent
    elsif (option == "CC" && @landing_appointments.cc_appointment_element.enabled?)
      @@ccEnabled = isCCEnabled
      @landing_appointments.select_cc_appointment
    end

  end

  def goBack
    button_element = @driver.button(:id => 'back-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    @modal.modalDialog_element.when_present(TIME_OUT_LIMIT)
    expect(@modal.modalTitle).to eq("Confirmation")
    expect(@modal.buttons_elements[0].text).to eq("Continue")
    @modal.buttons_elements[0].click
    waitWhileSpinnerPresent
  end

  def isCCEnabled
    cc_present = false
    if (@landing_appointments.cc_appointment_element.present? == true)
      cc_present = true
    end
    return cc_present
  end
end